
/*

`Form.LIST_CURRENT`は、リストボックスに定義してある

*/

Case of 
		//mark: -
	: (Form:C1466.LIST_CURRENT=Null:C1517)
		
		//mark: リスト項目が未選択のとき
		
		//本例題では、ここに来ることはない
		ALERT:C41("ファイルを選択してください")
		
		
		//mark: -
	: (Form:C1466.LIST_CURRENT#Null:C1517)
		
		//mark: リスト項目が選択されているとき
		
		CONFIRM:C162("ファイル「"+Form:C1466.LIST_CURRENT.fullName+"」を書き出しますか？")
		If (OK=1)
			
			//todo: サイズが大きなファイルのときなど時間がかかるときは、プログレスバーなどを利用して処理中であることをアピールすることを検討すること
			If (Form:C1466.LIST_CURRENT.size>(10*1024*1024))  //10mbを超えたとき
				CONFIRM:C162("サイズが大きいので転送に時間がかかるかもしれません"; "了解")
				If (OK#1)
					return   //処理の中断
				End if 
			End if 
			
			//mark: サーバーからファイルを転送して書き出す
			$path:=Select folder:C670("書き出すフォルダーを指定してください")
			If (OK=1)
				//mark: ファイル書き出し処理
				$content:=Form:C1466.LIST_CURRENT.getContent()
				$result:=File:C1566($path+Form:C1466.LIST_CURRENT.fullName; fk platform path:K87:2).setContent($content)
				SHOW ON DISK:C922($path+Form:C1466.LIST_CURRENT.fullName)
			End if 
			
		End if 
		
End case 
